<?php include('./header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
    </div>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
        </div>
      </div>
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-12">
              <div class="card card-default">
                <div class="card-body button-nav">
                  <div class="row float-right">
                    <div class="col-md-12">
                      <button class="btn btn-opcao" id="btn-preview" disabled>Pré-visualizar</button>
                      <button class="btn btn-opcao">Importar</button>
                      <button class="btn btn-opcao botao-activo" id="btn">Novo Tipo de Usuário</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-12">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Listagem dos Tipos de Usuário</h3>
                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <div class="card-body">
                  <table id="tabelaTipoUsuario" class="table table-bordered table-striped">
                    <thead>
                      <tr style="text-align: center;">
                        <th title="Identificador do Tipo de Usuário">Ref. Tipo de Usuário</th>
                        <th title="Descrição da Tipo de Usuário">Descrição</th>
                        <th title="Observações Tipo de Usuário">Observação</th>
                        <th title="Opções"><i class="fa-solid fa-screwdriver-wrench"></i></th>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
                <div class="card-footer">
                  Listagem dos Tipo de Usuários.
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <div class="modal fade" id="modal-documento">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <div class="container">
                <div class="progress-barra">
                  <div class="step">
                    <p style="margin: 0;">Formulário de Tipo de Usuário</p>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-body">
              <div class="container">
                <div class="card-body form-outer" style="padding: 0;">
                  <div class="formulario">
                    <div class="page slidePage">
                      <div class="row">
                        <div class="col-md-12">
                          <h5 style="margin-bottom: 1rem; justify-content: center;"><span id="doOpcao"></span> - <span id="codigo"></span></h5>
                          <div class="row">
                            <div class="col-md-10"></div>
                            <div class="col-md-6">
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Descrição</small>
                                <input type="text" class="form-control" id="nome" placeholder="Descrição" title="Descrição" data-campo="Nome">
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="not-required">Observações</small>
                                <textarea rows="4" type="text" class="form-control" id="nota" placeholder="Observações" title="Observações" data-campo="Observações"></textarea>
                                <small>Mensagem de erro</small>
                              </div>
                              <div class="form-group" style="margin-bottom: 0;">
                                <small class="required">Prazo de Pagamento</small>
                                <select class="form-control select2" style="width: 100%;" id="prazoPagamento" data-campo="Prazo de Pagamento">
                                <option value="0">Vazio</option>
                                <option value="1">Primeiro</option>
                                <option value="2">Segundo</option>
                                <option value="3">Terceiro</option>
                                </select>
                                <small>Mensagem de erro</small>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-12" style=" bottom: 0; padding-top: 14px;">
                          <div class="form-group margem">
                            <small>Mensagem de erro</small>
                            <div class="form-group field btns">
                              <button class="btn btn-block btn-primary submit next" style="margin-top: 0;">
                                Gravar Tipo de Usuário
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="col-md-12" id="footerPagamento" style="opacity: 0;">
                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span id="totalEntregue">ENTREGUE</span><span id="entregueSpan">0,00 Kzs</span></h4>
                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span class="text-danger" id="totalText">TOTAL</span><span class="text-danger" id="totalSpan">0,00 Kzs</span></h4>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="modal fade" id="modal-cliente">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Entidades</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <table id="tabelaCliente" class="table table-hover table-bordered table-striped">
                <thead>
                  <tr style="text-align: center;">
                    <th title="Identificador da Entidade">Ref. Entidade</th>
                    <th title="Nome">Nome</th>
                    <th title="Nome Comercial">Nome Comercial</th>
                    <th title="Bilhete de Identidade do Cliente">B.I</th>
                    <th title="NIF do Cliente">NIF</th>
                    <th title="Localidade do Cliente">Localidade</th>
                    <th title="Data de Nascimento do Cliente">Data Nasc.</th>
                    <th title="Morada do Cliente">Morada</th>
                    <th title="Tipo">Tipo</th>
                    <th title="Estado do Cliente">Estado</th>
                  </tr>
                </thead>
                <tbody style="text-align: center;">
                </tbody>
              </table>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
              <button type="button" class="btn btn-primary">Confirmar</button>
            </div>
          </div>
        </div>
      </div>
      <div class="modal fade" id="modal-artigo">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Artigos</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <table id="tabelaArtigoListagem" class="table table-hover table-bordered table-striped">
                <thead>
                  <tr style="text-align: center;">
                    <th title="Referência">Referência</th>
                    <th title="Descrição do Artigo">Descrição</th>
                    <th title="Tipo de Usuário">Tipo de Usuário</th>
                    <th title="Preço do Artigo (S/Imp)">Preço (S/Imp)</th>
                    <th title="Preço do Artigo (C/Imp)">Preço (C/Imp)</th>
                    <th title="Qtd. Stock">Qtd. Stock</th>
                  </tr>
                </thead>
                <tbody style="text-align: center;">
                </tbody>
              </table>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
              <button type="button" class="btn btn-primary">Confirmar</button>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="modal-updateTipoEntidade">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header" style="padding: 0.5rem;">
            <h3 class="card-title p-3">Tipo de Usuário: <span id="nomeModal"></span></h3>
          </div>
          <div class="modal-body" style="padding-bottom: 0px;">
            <div class="row">
              <div class="col-md-12">
                <form name="tabelaInfo">
                  <table name="tabelaInfo" class="table table-sm table-bordered" style="min-width: 100%;
                      max-width: 100%;">
                    <tr name="linhaItem">
                      <td style="padding: 20px 0px 0px 10px;">
                        <p>Ref. da Tipo de Usuário: <span id="codigoInfo"></span></p>
                        <p>Descrição: <span id="nomeInfo"></span></p>
                        <p>Observações: <span id="notaInfo"></span></p>
                      </td>
                    </tr>
                  </table>
                </form>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
        </div>
      </div>
    </div>
    <?php include('footer.php'); ?>
</body>
</html>
<script>
  let linha;

  function detalhes(id) {
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
      idTipoUsuario: id
    }, "tipoUsuario", function success(data) {
      for (var key in data) {
        nomeModal.innerText = data[key]["nome"];
        codigoInfo.innerText = data[key]["idTipoUsuario"];
        nomeInfo.innerText = data[key]["nome"];
        notaInfo.innerText = data[key]["nota"];
      }
    }, function error(data) {

    }, function done(data) {

    });
  }
  botaoOutrasOpcoes(document.querySelectorAll(".btn-opcao"));
  linhaSelecionada("tabelaTipoUsuario", document.querySelector("#btn-preview"));
  funcaoSelect("includes/select.inc.php", "post", "json", "tipoUsuario", function success(data) {
    $("#tabelaTipoUsuario").DataTable({
      select: 'single',
      "aaData": data,
      "columns": [{
        data: "idTipoUsuario"
      }, {
        data: "nome"
      }, {
        data: "nota"
      }, {
        data: null,
        render: function(data, type, row) {
          return `
            <div id="dropdownOpcoes" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="display:flex; align-items: center; justify-content: space-around;"><button class="btn btn-outline-primary opcoes" style="padding: .2rem .7rem; line-height: 1; border: none;"><i class="fa-solid fa-ellipsis-vertical"></i></button></div>
            <ul aria-labelledby="dropdownOpcoes" class="dropdown-menu border-0 shadow">
              <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-more" style="padding: .8rem; border-radius: 5px;">Informações</a></li>
              <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-update" style="padding: .8rem; border-radius: 5px;">Editar</a></li>
              <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-delete" style="padding: .8rem; border-radius: 5px;">Eliminar</a></li>
            </ul>`;
        }
      }],
      columnDefs: [{
        targets: -1,
        orderable: false
      }],
      "responsive": true,
      "lengthChange": false,
      "autoWidth": false,
      "language": idiomaPortugues,
      lengthMenu: [
        [7, 25, 50, -1],
        [10, 25, 50, 'All']
      ],
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tabelaTipoUsuario_wrapper .col-md-6:eq(0)');
  }, function error(data) {

  }, function done(data) {

  });


  $(document).on("click", "#btn-preview", function(e) {
    e.preventDefault();
    $('#modal-updateTipoEntidade').modal('show');
  });

  $('#tabelaTipoUsuario').on('click', '.btn-more', function(e) {
    e.preventDefault();
    $('#modal-updateTipoEntidade').modal('show');
    detalhes($(this).closest('tr').find('td')[0].textContent);
  });

  let id = {
    idCodigoTaxa: 1
  }
  let tabela = "tipoUsuario";

  function updateLinha(id, tabela) {
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", id, tabela, function success(data) {
      for (var key in data) {
        linha[1].innerText = data[key]["nome"];
        linha[2].innerText = data[key]["nota"];
      }
    }, function error(data) {

    }, function done(data) {

    });
  }

  function insertLinha(id, tabela) {
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", id, tabela, function success(data) {
      for (var key in data) {
        var novaLinha = {
          idTipoUsuario: data[key]["idTipoUsuario"],
          nome: data[key]["nome"],
          nota: data[key]["nota"],
        };
        $('#tabelaTipoUsuario').DataTable().row.add(novaLinha).draw(false);
      }
    }, function error(data) {

    }, function done(data) {

    });
  }

  function loadNovoId() {
    funcaoAutoIncrement("includes/autoIncrement.inc.php", "post", "json", "dbbuesimples", "tipoUsuario", "tu", function success(data) {
      codigo.innerText = data[0]["tu"];
    }, function error(data) {

    }, function done(data) {

    });
  }

  $(document).on("click", ".submit", function(e) {
    e.preventDefault();
    if (nome.value != '') {
      tipoUsuario();
    }
  });

  $(document).on("click", "#btn", function(e) {
    e.preventDefault();
    doOpcao.innerText = "Novo Tipo de Usuário";
    funcaoReload(document.querySelector(".submit"));

    $('#modal-documento').modal('show');
  });

  function tipoUsuario() {
    let dados = {
      nome: nome.value,
      nota: nota.value,
    };
    let tabela = "tipoUsuario";
    if (doOpcao.innerText == "Novo Tipo de Usuário") {
      funcaoInsert("includes/insert.inc.php", "post", "json", tabela, dados, function success(data) {
        swal.fire({
          title: "Cadastro efectuado com sucesso!",
          text: "Tipo de Usuário " + nome.value + " cadastrado!",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "success",
        });
        insertLinha({
          idTipoUsuario: data
        }, tabela);
        funcaoReload(document.querySelector(".submit"));
      }, function error(data) {
        swal.fire({
          title: "Erro ao cadastrar Tipo de Usuário!",
          text: "Erro ao cadastrar Tipo de Usuário: " + nome.value + " !",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "error",
        });
      }, function done(data) {

      });
    } else {
      funcaoUpdate("includes/update.inc.php", "post", "json", tabela, dados, {
        idTipoUsuario: codigo.innerText
      }, function success(data) {
        swal.fire({
          title: "Informações Actualizadas com sucesso!",
          text: "Tipo de Usuário " + nome.value + ".",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "success",
        });
        updateLinha({
          idTipoUsuario: codigo.innerText
        }, tabela);
        funcaoReload(document.querySelector(".submit"));
      }, function error(data) {
        console.log("Erro: ", data);
        swal.fire({
          title: "Erro ao actualizar Tipo de Usuário!",
          text: "Erro ao actualizar Tipo de Usuário: " + nome.value + " !",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "error",
        });
      }, function done(data) {

      });
    }
  }

  $('#tabelaTipoUsuario').on('click', '.btn-more', function(e) {
    e.preventDefault();
    $('#modal-updateTipoEntidade').modal('show');
    linha = $(this).closest('tr').find('td');
    detalhes($(this).closest('tr').find('td')[0].textContent);
  });

  $('#tabelaTipoUsuario').on('click', '.btn-update', function(e) {
    e.preventDefault();
    linha = $(this).closest('tr').find('td');
    doOpcao.innerText = "Editar Tipo de Usuário";
    resetForm(document.querySelector(".slidePage"));
    $('#modal-documento').modal('show');
    let id = $(this).closest('tr').find('td')[0].textContent;
    funcaoQuerySelect("includes/querySelect.inc.php", "post", "json", {
      idTipoUsuario: id
    }, "tipoUsuario", function success(data) {
      for (var key in data) {
        codigo.innerText = data[key]["idTipoUsuario"];

        if (data[key]["nome"] != "") {
          nome.value = data[key]["nome"];
        } else {
          nome.value = "";
        }

        if (data[key]["nota"] != "") {
          nota.value = data[key]["nota"];
        } else {
          nota.value = "";
        }
      }
    }, function error(data) {

    }, function done(data) {

    });
  });

  $('#tabelaTipoUsuario').on('click', '.btn-delete', function(e) {
    e.preventDefault();
    linha = $(this).closest('tr').find('td');
    let id = $(this).closest('tr').find('td')[0].textContent;
    let nome = $(this).closest('tr').find('td')[1].textContent;
    swal.fire({
        title: "Tem a certeza que pretende eliminar Tipo de Usuário?",
        text: "Tipo de Usuário: " + nome,
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: 'Confirmar',
        confirmButtonColor: '#560085',
        cancelButtonText: 'Cancelar',
        cancelButtonColor: '#560085',
      })
      .then((result) => {
        if (result.isConfirmed) {
          funcaoDelete("includes/delete.inc.php", "post", "json", tabela, {
            idTipoUsuario: id
          }, function success(data) {
            console.log(data);
            swal.fire({
              title: "Tipo de Usuário " + nome + " eliminado com sucesso!",
              icon: "success",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
            });
            $('#tabelaTipoUsuario').DataTable().row(linha).remove().draw(false);
            funcaoReload(document.querySelector(".submit"));
          }, function error(data) {
            console.log(data);
            swal.fire({
              title: "Erro ao eliminar Tipo de Usuário!",
              text: "Tipo de Usuário associado a uma ou mais Documentos.",
              icon: "error",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
            });
          }, function done(data) {

          });
        }
      });
  });
</script>
<script src="./javascript/validation.js"></script>