const nome = document.getElementById("nome");
const nota = document.getElementById("nota");
const btn = window.parent.document.getElementById("btn-submit");

const slidePage = document.querySelector(".slidePage");
const firstNextBtn = document.querySelector(".nextBtn");
const prevBtnSec = document.querySelector(".prev-1");
const nextBtnSec = document.querySelector(".next-1");
const prevBtnThird = document.querySelector(".prev-2");
const nextBtnThird = document.querySelector(".next-2");
const prevBtnFourth = document.querySelector(".prev-3");
const submitBtn = document.querySelector(".submit");
const progressText = document.querySelectorAll(".step p");
const progressCheck = document.querySelectorAll(".step .check");
const bullet = document.querySelectorAll(".step .bullet");

const footerPagamento = document.getElementById("footerPagamento");

let numberRegExp = new RegExp('^[0-9-()-+ ]+$');
let letterRegExp = new RegExp('^[a-zA-Z ]+$');
let biRegExp = new RegExp('^[a-zA-Z0-9]+$');
let emailRegExp = new RegExp('^[A-Za-z0-9._-]{3,}@[A-Za-z._-]{3,}[.]{1}[A-Za-z.]{2,6}$');

let max = 1;
let current = 1;

function nomeWarning(small){
	nome.className = "form-control is-warning";
	small.style.visibility = "visible";
	small.style.color = "#ffc107";
	small.innerText = "Campo Descrição é obrigatório!";
	submitBtn.setAttribute('disabled', 'disabled');
}

function nomeValid(small){
	nome.className = "form-control is-valid";
	submitBtn.removeAttribute('disabled');
	small.style.visibility = "hidden";
}

nome.addEventListener("keyup", function(){
	let small = nome.parentElement.querySelectorAll("small")[1];
	if(nome.value === ''){
		nomeWarning(small);
	} else {
		nomeValid(small);
	}
});

function notaNormal(small){
	nota.className = "form-control";
	small.style.visibility = "hidden";
	small.style.color = "#ffc107";
	small.innerText = "Campo Observações é obrigatório!";
	submitBtn.removeAttribute('disabled');
}

function notaValid(small){
	nota.className = "form-control is-valid";
	submitBtn.removeAttribute('disabled');
	small.style.visibility = "hidden";
}

nota.addEventListener("keyup", function(){
	let small = nota.parentElement.querySelectorAll("small")[1];
	if(nota.value === ''){
		notaNormal(small);
	} else {
		notaValid(small);
	}
});

submitBtn.addEventListener("click", function(){
	let smallNome = nome.parentElement.querySelectorAll("small")[1];
	let smallNota = nota.parentElement.querySelectorAll("small")[1];
	if(nome.value == ''){
        nomeWarning(smallNome);
    } else {
		nomeValid(smallNome);
	}

	if(nota.value == ''){
        notaNormal(smallNota);
    } else {
		notaValid(smallNota);
	}
});

function resetForm(){
    slidePage.style.marginLeft = "0%";
    current = 1;
}